<?php

use App\Models\Mission;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mission_levels', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Mission::class)->constrained();
            $table->unsignedInteger('level');
            $table->unsignedInteger('cost');
            $table->unsignedInteger('production_per_hour');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mission_levels');
    }
};
